% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu  2012, version: 31Mar2012
% TITLE: Quantifiable value of information in direct marketing
% Related web page:
% http://finaquant.com/quantifiable-value-of-information-in-direct-marketing/796
% assumed conditional probabilty of response
function CondProb = response_probability(PurchaseAmount)
% CondProb = (10 + PurchaseAmount * 0.2) / 200 + 0.02 * sin(PurchaseAmount/50);

CondProb = (5 + (PurchaseAmount/100) .^ 2);

% scale to probabilities
maxProb = 0.70; % higher limit
minProb = 0.02;  % lower limit

CondProb = CondProb - min(CondProb);
CondProb = CondProb / max(CondProb) * (maxProb - minProb);
CondProb = CondProb + minProb;